<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

include 'db.php';

// Delete functionality
if (isset($_GET['delete_id']) && is_numeric($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete_id']);
    $delete_query = "DELETE FROM newsletter_submissions WHERE id = $delete_id";
    if (mysqli_query($conn, $delete_query)) {
        $delete_message = "<div style='color: green; margin-bottom: 10px;'>Record deleted successfully.</div>";
    } else {
        $delete_message = "<div style='color: red; margin-bottom: 10px;'>Error deleting record: " . mysqli_error($conn) . "</div>";
    }
}

$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';
$query = "SELECT * FROM newsletter_submissions WHERE name LIKE '%$searchTerm%' OR mobile LIKE '%$searchTerm%' OR email LIKE '%$searchTerm%'";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Newsletter Submissions</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        /* General Body Styling */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
            color: #333;
            display: flex;
            min-height: 100vh;
        }

        /* Content Section */
        .content {
            flex: 1;
            padding: 30px;
            background-color: #fff;
            color: #333;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.02);
            margin-left: 220px; /* Adjust to sidebar width */
        }

        h1 {
            font-size: 28px;
            color: #333;
            margin-bottom: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            display: flex;
            align-items: center;
        }

        h1 i {
            margin-right: 10px;
            color: #007bff;
        }

        form {
            display: flex;
            align-items: center;
            margin-bottom: 25px;
        }

        form input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ddd;
            margin-right: 10px;
            width: 300px;
            transition: border-color 0.3s ease;
        }

        form input[type="text"]:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
        }

        form button {
            padding: 10px 15px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #0056b3;
        }

        /* Professional Table Styling */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border-radius: 8px;
            overflow: hidden;
            border: 1px solid #e0e0e0;
            background-color: #fff;
        }

        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        th {
            background-color: #f8f9fa;
            color: #495057;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        td a {
            padding: 8px 12px;
            margin-right: 5px;
            color: #fff;
            text-decoration: none;
            border-radius: 6px;
            transition: background-color 0.2s ease;
            display: inline-block;
            font-size: 0.9em;
        }

        .delete-btn {
            background-color: #dc3545; /* Red delete button */
        }

        .delete-btn:hover {
            background-color: #c82333;
        }
    </style>
</head>
<body>
    <?php include 'sidebar.php'; ?>

    <div class="content">
        <h1><i class="far fa-envelope"></i> Newsletter Submissions</h1>
        <?php if (isset($delete_message)) echo $delete_message; ?>
        <form method="GET" action="">
            <input type="text" name="search" placeholder="<i class='fas fa-search'></i> Search by name, mobile or email" value="<?php echo htmlspecialchars($searchTerm); ?>">
            <button type="submit"><i class="fas fa-search"></i> Search</button>
        </form>

        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Mobile</th>
                    <th>Email</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td data-label="Name"><?php echo htmlspecialchars($row['name']); ?></td>
                            <td data-label="Mobile"><?php echo htmlspecialchars($row['mobile']); ?></td>
                            <td data-label="Email"><?php echo htmlspecialchars($row['email']); ?></td>
                            <td data-label="Actions">
                                <a href="?delete_id=<?php echo $row['id']; ?>" class="delete-btn" onclick="return confirm('Are you sure you want to delete this submission?')"><i class="fas fa-trash-alt"></i> Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="4">No results found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>