<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

include 'db.php';

// Search functionality
$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';
$query = "SELECT * FROM main_form WHERE organization LIKE '%$searchTerm%' OR developer LIKE '%$searchTerm%' OR industry LIKE '%$searchTerm%'";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Main Form Submissions</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        /* General Body Styling */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
            color: #333;
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Styling */
        .sidebar {
            background-color: #fff;
            color: #555;
            width: 220px;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 20px;
            box-shadow: 1px 0 10px rgba(0, 0, 0, 0.05);
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            z-index: 100;
        }

        .sidebar .logo {
            padding: 20px;
            text-align: left;
            border-bottom: 1px solid #eee;
            margin-bottom: 20px;
            width: 100%;
        }

        .sidebar .logo a {
            display: block;
            text-decoration: none;
            color: #333;
            font-size: 1.4em;
            font-weight: bold;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
            margin-top: 10px;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 5px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: #555;
            transition: background-color 0.3s ease;
            border-left: 3px solid transparent;
            width: 100%;
            box-sizing: border-box;
        }

        .sidebar ul li a i {
            margin-right: 15px;
            font-size: 1em;
            width: 20px;
            text-align: center;
            color: #777;
        }

        .sidebar ul li a span {
            flex-grow: 1;
        }

        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background-color: #f9f9f9;
            color: #333;
            border-left-color: #007bff;
            font-weight: bold;
        }

        .sidebar ul li a.active i {
            color: #007bff;
        }

        /* Content Section */
        .content {
            margin-left: 220px;
            padding: 30px;
            background-color: #fff;
            min-height: 100vh;
            color: #333;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.02);
            width: calc(100% - 220px);
        }

        h1 {
            font-size: 28px;
            color: #333;
            margin-bottom: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            display: flex;
            align-items: center;
        }

        h1 i {
            margin-right: 10px;
            color: #007bff;
        }

        form {
            display: flex;
            align-items: center;
            margin-bottom: 25px;
        }

        form input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ddd;
            margin-right: 10px;
            width: 300px;
            transition: border-color 0.3s ease;
        }

        form input[type="text"]:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
        }

        form button {
            padding: 10px 15px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #0056b3;
        }

        /* Professional Table Styling */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border-radius: 8px;
            overflow: hidden;
            border: 1px solid #e0e0e0;
            background-color: #fff;
        }

        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        th {
            background-color: #f8f9fa;
            color: #495057;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        td a {
            padding: 8px 12px;
            margin-right: 5px;
            color: #fff;
            text-decoration: none;
            border-radius: 6px;
            transition: background-color 0.2s ease;
            display: inline-block;
            font-size: 0.9em;
        }

        .edit-btn {
            background-color: #28a745;
        }

        .delete-btn {
            background-color: #dc3545;
        }

        .edit-btn:hover {
            background-color: #1e7e34;
        }

        .delete-btn:hover {
            background-color: #c82333;
        }

        /* Responsive Table */
        @media (max-width: 768px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }

            thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }

            tr {
                border: 1px solid #e0e0e0;
                margin-bottom: 15px;
                border-radius: 8px;
                overflow: hidden;
            }

            td {
                border: none;
                border-bottom: 1px solid #e0e0e0;
                position: relative;
                padding-left: 50%;
                text-align: left;
            }

            td:before {
                content: attr(data-label);
                position: absolute;
                left: 10px;
                font-weight: bold;
            }

            form {
                flex-direction: column;
                align-items: flex-start;
            }

            form input[type="text"] {
                width: 100%;
                margin-bottom: 10px;
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <?php include 'sidebar.php'; ?>

    <div class="content">
        <h1><i class="fas fa-file-alt"></i> Main Form Submissions</h1>

        <form method="GET" action="">
            <input type="text" name="search" placeholder="<i class='fas fa-search'></i> Search Organization, Developer, Industry" value="<?= htmlspecialchars($searchTerm) ?>">
            <button type="submit"><i class="fas fa-search"></i> Search</button>
        </form>

        <table>
            <thead>
                <tr>
                    <th>Organization</th>
                    <th>Developer</th>
                    <th>Industry</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Address</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                    <tr>
                        <td data-label="Organization"><?= htmlspecialchars($row['organization']) ?></td>
                        <td data-label="Developer"><?= htmlspecialchars($row['developer']) ?></td>
                        <td data-label="Industry"><?= htmlspecialchars($row['industry']) ?></td>
                        <td data-label="Email"><?= htmlspecialchars($row['email']) ?></td>
                        <td data-label="Phone"><?= htmlspecialchars($row['phone']) ?></td>
                        <td data-label="Address"><?= htmlspecialchars($row['address']) ?></td>
                        <td data-label="Actions">
                            <a href="edit_main_form.php?id=<?= $row['id'] ?>" class="edit-btn" style="background-color: #28a745; color: white; padding: 8px 12px; border-radius: 6px; text-decoration: none; font-size: 0.9em; margin-right: 5px;"><i class="fas fa-edit"></i> Edit</a>
                            <a href="delete_main_form.php?id=<?= $row['id'] ?>" class="delete-btn" style="background-color: #dc3545; color: white; padding: 8px 12px; border-radius: 6px; text-decoration: none; font-size: 0.9em;" onclick="return confirm('Are you sure you want to delete this?')"><i class="fas fa-trash-alt"></i> Delete</a>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.querySelector('.sidebar');
            const sidebarHTML = `
                <div class="logo" style="padding: 20px; text-align: center; border-bottom: 1px solid #495057; margin-bottom: 20px; width: 100%;">
                    <a href="dashboard.php" style="display: block; text-decoration: none; color: #fff; font-size: 1.5em; font-weight: bold;">Admin Panel</a>
                </div>
                <ul class="sidebar-menu" style="list-style: none; padding: 0; margin-top: 15px; width: 100%;">
                    <li class="menu-item" style="margin-bottom: 5px;">
                        <a href="dashboard.php" class="sidebar-link active" style="display: flex; align-items: center; padding: 12px 20px; text-decoration: none; color: #fff; transition: background-color 0.3s ease; border-left: 4px solid #007bff; width: 100%; box-sizing: border-box; font-weight: 500; background-color: rgba(255, 255, 255, 0.05);">
                            <i class="fas fa-tachometer-alt" style="margin-right: 15px; font-size: 1em; width: 20px; text-align: center; color: #007bff;"></i>
                            <span style="flex-grow: 1;">Dashboard</span>
                        </a>
                    </li>
                    <li class="menu-item" style="margin-bottom: 5px;">
                        <a href="main_form_submissions.php" class="sidebar-link" style="display: flex; align-items: center; padding: 12px 20px; text-decoration: none; color: #adb5bd; transition: background-color 0.3s ease; border-left: 4px solid transparent; width: 100%; box-sizing: border-box;">
                            <i class="far fa-file-alt" style="margin-right: 15px; font-size: 1em; width: 20px; text-align: center; color: #6c757d;"></i>
                            <span style="flex-grow: 1;">Main Form Submissions</span>
                        </a>
                    </li>
                    <li class="menu-item" style="margin-bottom: 5px;">
                        <a href="newsletter_submissions.php" class="sidebar-link" style="display: flex; align-items: center; padding: 12px 20px; text-decoration: none; color: #adb5bd; transition: background-color 0.3s ease; border-left: 4px solid transparent; width: 100%; box-sizing: border-box;">
                            <i class="far fa-envelope" style="margin-right: 15px; font-size: 1em; width: 20px; text-align: center; color: #6c757d;"></i>
                            <span style="flex-grow: 1;">Newsletter Submissions</span>
                        </a>
                    </li>
                    <li class="menu-item" style="margin-bottom: 5px;">
                        <a href="logout.php" class="sidebar-link logout" style="display: flex; align-items: center; padding: 12px 20px; text-decoration: none; color: #adb5bd; transition: background-color 0.3s ease; border-left: 4px solid transparent; width: 100%; box-sizing: border-box; margin-top: auto; border-top: 1px solid #495057;">
                            <i class="fas fa-sign-out-alt" style="margin-right: 15px; font-size: 1em; width: 20px; text-align: center; color: #6c757d;"></i>
                            <span style="flex-grow: 1;">Logout</span>
                        </a>
                    </li>
                </ul>
            `;
            if (sidebar) {
                sidebar.innerHTML = sidebarHTML;
            }

            const content = document.querySelector('.content');
            if (content) {
                content.style.marginLeft = '220px';
                content.style.padding = '30px';
                content.style.backgroundColor = '#fff';
                content.style.minHeight = '100vh';
                content.style.color = '#333';
                content.style.borderRadius = '8px';
                content.style.boxShadow = '0 0 10px rgba(0, 0, 0, 0.02)';
                content.style.width = 'calc(100% - 220px)';
            }

            const h1 = document.querySelector('.content h1');
            if (h1) {
                h1.style.fontSize = '28px';
                h1.style.color = '#333';
                h1.style.marginBottom = '20px';
                h1.style.borderBottom = '2px solid #eee';
                h1.style.paddingBottom = '10px';
                h1.style.display = 'flex';
                h1.style.alignItems = 'center';
            }