<?php
include 'db.php';
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$id = $_GET['id'];
if (!is_numeric($id)) {
    // Handle invalid ID
    echo "<div style='color: red; margin: 20px;'>Invalid submission ID.</div>";
    exit;
}
$query = "SELECT * FROM main_form WHERE id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$data) {
    // Handle non-existent record
    echo "<div style='color: red; margin: 20px;'>Submission not found.</div>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $organization = mysqli_real_escape_string($conn, $_POST['organization']);
    $developer = mysqli_real_escape_string($conn, $_POST['developer']);
    $industry = mysqli_real_escape_string($conn, $_POST['industry']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);

    $update = "UPDATE main_form SET
        organization=?,
        developer=?,
        industry=?,
        email=?,
        phone=?,
        address=?
        WHERE id=?";

    $stmt_update = mysqli_prepare($conn, $update);
    mysqli_stmt_bind_param($stmt_update, "ssssssi", $organization, $developer, $industry, $email, $phone, $address, $id);

    if (mysqli_stmt_execute($stmt_update)) {
        header("Location: main_form_submissions.php");
        exit;
    } else {
        echo "<div style='color: red; margin: 20px;'>Error updating record: " . mysqli_error($conn) . "</div>";
    }
    mysqli_stmt_close($stmt_update);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Submission</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            background-color: #f4f6f8;
            color: #333;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 30px;
        }

        h2 {
            color: #333;
            margin-bottom: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
            width: 500px;
            max-width: 90%;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }

        input[type="text"],
        textarea {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            box-sizing: border-box;
        }

        textarea {
            resize: vertical;
            min-height: 100px;
        }

        button[type="submit"] {
            padding: 10px 20px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        button[type="submit"]:hover {
            background-color: #0056b3;
        }

        a {
            display: inline-block;
            margin-top: 20px;
            color: #007bff;
            text-decoration: none;
            font-size: 16px;
            transition: color 0.3s ease;
        }

        a:hover {
            color: #0056b3;
            text-decoration: underline;
        }

        .error-message {
            color: red;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <h2><i class="fas fa-edit mr-2"></i> Edit Submission</h2>
    <form method="POST">
        <label for="organization">Organization:</label>
        <input type="text" name="organization" id="organization" value="<?= htmlspecialchars($data['organization']) ?>" required><br>

        <label for="developer">Developer:</label>
        <input type="text" name="developer" id="developer" value="<?= htmlspecialchars($data['developer']) ?>" required><br>

        <label for="industry">Industry:</label>
        <input type="text" name="industry" id="industry" value="<?= htmlspecialchars($data['industry']) ?>" required><br>

        <label for="email">Email:</label>
        <input type="text" name="email" id="email" value="<?= htmlspecialchars($data['email']) ?>" required><br>

        <label for="phone">Phone:</label>
        <input type="text" name="phone" id="phone" value="<?= htmlspecialchars($data['phone']) ?>" required><br>

        <label for="address">Address:</label>
        <textarea name="address" id="address"><?= htmlspecialchars($data['address']) ?></textarea><br>

        <button type="submit"><i class="fas fa-save mr-2"></i> Update</button>
    </form>
    <a href="main_form_submissions.php"><i class="fas fa-arrow-left mr-2"></i> Back to Submissions</a>
</body>
</html>