<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

include 'db.php';

// Count total main form submissions
$sql_main_count = "SELECT COUNT(*) AS total_main FROM main_form";
$result_main_count = mysqli_query($conn, $sql_main_count);
$row_main_count = mysqli_fetch_assoc($result_main_count);
$total_main_submissions = $row_main_count['total_main'];

// Count total newsletter submissions
$sql_newsletter_count = "SELECT COUNT(*) AS total_newsletter FROM newsletter_submissions";
$result_newsletter_count = mysqli_query($conn, $sql_newsletter_count);
$row_newsletter_count = mysqli_fetch_assoc($result_newsletter_count);
$total_newsletter_submissions = $row_newsletter_count['total_newsletter'];

// Get the latest 5 main form submissions
$sql_latest_main = "SELECT id, organization, developer FROM main_form ORDER BY id DESC LIMIT 5";
$result_latest_main = mysqli_query($conn, $sql_latest_main);

// Get the latest 5 newsletter submissions
$sql_latest_newsletter = "SELECT id, name, email FROM newsletter_submissions ORDER BY id DESC LIMIT 5";
$result_latest_newsletter = mysqli_query($conn, $sql_latest_newsletter);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        /* Global Styles */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
            color: #333;
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            background-color: #2c3e50;
            color: white;
            width: 220px;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 20px;
            box-shadow: 1px 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            z-index: 100;
        }

        .sidebar h2 {
            padding: 20px;
            text-align: left;
            border-bottom: 1px solid #34495e;
            margin-bottom: 20px;
            width: 100%;
            font-size: 1.6em;
            font-weight: bold;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
            margin-top: 10px;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 5px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: #eee;
            transition: background-color 0.3s ease;
            border-left: 3px solid transparent;
            width: 100%;
            box-sizing: border-box;
        }

        .sidebar ul li a i {
            margin-right: 15px;
            font-size: 1em;
            width: 20px;
            text-align: center;
            color: #ddd;
        }

        .sidebar ul li a span {
            flex-grow: 1;
        }

        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background-color: rgba(255, 255, 255, 0.05);
            color: #fff;
            border-left-color: #007bff;
            font-weight: 500;
        }

        .sidebar ul li a.active i {
            color: #007bff;
        }

        .sidebar form {
            margin-top: auto;
            padding: 20px;
            border-top: 1px solid #34495e;
            width: 100%;
            box-sizing: border-box;
        }

        .sidebar .logout-btn {
            display: block;
            width: 100%;
            padding: 10px;
            background: #e74c3c;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            font-size: 1em;
        }

        .sidebar .logout-btn:hover {
            background: #c0392b;
        }

        /* Content Area */
        .content {
            flex: 1;
            padding: 30px;
            margin-left: 220px; /* Match sidebar width */
        }

        h1 {
            color: #2c3e50;
            margin-bottom: 25px;
            border-bottom: 2px solid #eee;
            padding-bottom: 12px;
            display: flex;
            align-items: center;
        }

        h1 i {
            margin-right: 10px;
            color: #007bff;
        }

        .dashboard-widgets {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .widget {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .widget h3 {
            margin-top: 0;
            color: #333;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            font-size: 1.2em;
        }

        .widget h3 i {
            margin-right: 10px;
            color: #6c757d;
        }

        .widget .value {
            font-size: 2.5em;
            color: #007bff;
            font-weight: bold;
        }

        .latest-submissions {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
        }

        .latest-submissions h3 {
            color: #333;
            margin-bottom: 15px;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
            display: flex;
            align-items: center;
            font-size: 1.2em;
        }

        .latest-submissions h3 i {
            margin-right: 10px;
            color: #6c757d;
        }

        .latest-submissions ul {
            list-style: none;
            padding-left: 0;
        }

        .latest-submissions ul li {
            padding: 10px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .latest-submissions ul li:last-child {
            border-bottom: none;
        }

        .latest-submissions ul li span {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <h2>Admin Panel</h2>
        <ul>
            <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a></li>
            <li><a href="main_form_submissions.php"><i class="far fa-file-alt"></i> <span>Main Form Submissions</span></a></li>
            <li><a href="newsletter_submissions.php"><i class="far fa-envelope"></i> <span>Newsletter Submissions</span></a></li>
        </ul>
        <form action="logout.php" method="POST">
            <button class="logout-btn" type="submit"><i class="fas fa-sign-out-alt"></i> Logout</button>
        </form>
    </div>

    <div class="content">
        <h1><i class="fas fa-tachometer-alt"></i> Dashboard</h1>

        <div class="dashboard-widgets">
            <div class="widget">
                <h3><i class="far fa-file-alt"></i> Total Main Form Submissions</h3>
                <div class="value"><?php echo $total_main_submissions; ?></div>
            </div>

            <div class="widget">
                <h3><i class="far fa-envelope"></i> Total Newsletter Submissions</h3>
                <div class="value"><?php echo $total_newsletter_submissions; ?></div>
            </div>
        </div>

        <div class="latest-submissions">
            <h3><i class="fas fa-list"></i> Latest Main Form Submissions</h3>
            <?php if (mysqli_num_rows($result_latest_main) > 0): ?>
                <ul>
                    <?php while ($row = mysqli_fetch_assoc($result_latest_main)): ?>
                        <li><span>ID:</span> <?php echo htmlspecialchars($row['id']); ?> - <span>Organization:</span> <?php echo htmlspecialchars($row['organization']); ?> (<span>Developer:</span> <?php echo htmlspecialchars($row['developer']); ?>)</li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>No main form submissions yet.</p>
            <?php endif; ?>
        </div>

        <div class="latest-submissions">
            <h3><i class="fas fa-envelope-open-text"></i> Latest Newsletter Submissions</h3>
            <?php if (mysqli_num_rows($result_latest_newsletter) > 0): ?>
                <ul>
                    <?php while ($row = mysqli_fetch_assoc($result_latest_newsletter)): ?>
                        <li><span>ID:</span> <?php echo htmlspecialchars($row['id']); ?> - <span>Name:</span> <?php echo htmlspecialchars($row['name']); ?> (<span>Email:</span> <?php echo htmlspecialchars($row['email']); ?>)</li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>No newsletter submissions yet.</p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>